%% The survival analysis between two clusters

function [Spatial_goodSurv, Spatial_badSurv] = InvestigateSurvTwoGroups(ID_goodSurv,ID_lowSurv,L_IDXs,S,indx_Neww,LOU_DataSetName,ColorMap)

 % Don't forget to load the clinical data
 LOUT_clinical_data_Edited = dataset('File',LOU_DataSetName);

clear X Y ClusterX ClusterY Groups
currentFolder  = pwd;
survivals = LOUT_clinical_data_Edited.Surv_time;
Censored = LOUT_clinical_data_Edited.Surv_status;
groups = LOUT_clinical_data_Edited.Var2;
groupX = ID_goodSurv;  %high Surv
groupY = ID_lowSurv;   %low Surv
ClusterX = find(groups == groupX); %Access the selected cluster
ClusterY = find(groups == groupY);
L1 = length(ClusterX);
L2 = length(ClusterY);
X(1:L1,1) = survivals(ClusterX);
X(1:L1,2) = Censored(ClusterX);
X(L1+1:L1+L2,1) = survivals(ClusterY);
X(L1+1:L1+L2,2) = Censored(ClusterY);
Groups(1:L1,1) = groupX;
Groups(L1+1:L1+L2,1) = groupY;
% [UL,SUL,z,p,alpha] = logrank(X(:,1),X(:,2))

p = Survival_TwoGroups(X,Groups,ColorMap,currentFolder);

% Spatial distribution of two subpopulations
Spatial_goodSurv =  Visualize_tSNE_2DImage(L_IDXs==groupX,S(1),S(2),indx_Neww); %Check groupX is high Surv
Spatial_badSurv = Visualize_tSNE_2DImage(L_IDXs==groupY,S(1),S(2),indx_Neww); %Check groupY is low Surv

% figure, imagesc(Spatial_goodSurv);
% figure, imagesc(Spatial_badSurv);
